/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.ChartGraphics;
import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Line3D;
import com.roguewave.chart.core.v2_1.graphics.Line3DDrawable;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Text2DDrawable;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import com.roguewave.chart.standard.v2_1.parts.Scale;
import java.awt.Color;
import java.awt.Font;
import java.util.Vector;

public class Chart2DXYScale
implements Scale {
    Vector drawables_ = null;
    Font font_ = new Font("TimesRoman", 0, 14);
    String[] strings_ = null;

    public Chart2DXYScale(ChartProperties properties, double width, double height, double minX, double minY, double maxX, double maxY, double xLowTick, double xIncrement, double yLowTick, double yIncrement, Transform3D transform) {
        Color color = (Color)properties.getProperty("ScaleGridColor", Color.black);
        Color labelColor = (Color)properties.getProperty("ScaleColor", Color.black);
        this.font_ = (Font)properties.getProperty("Scale2DFont", this.font_);
        this.drawables_ = new Vector();
        Point3D ul = transform.transform(new Point3D(-width / (double)2, height / (double)2, 0.0));
        Point3D ur = transform.transform(new Point3D(width / (double)2, height / (double)2, 0.0));
        Point3D lr = transform.transform(new Point3D(width / (double)2, -height / (double)2, 0.0));
        Point3D ll = transform.transform(new Point3D(-width / (double)2, -height / (double)2, 0.0));
        this.drawables_.addElement(new Line3DDrawable(new Line3D(ul, ur), color));
        this.drawables_.addElement(new Line3DDrawable(new Line3D(ur, lr), color));
        this.drawables_.addElement(new Line3DDrawable(new Line3D(lr, ll), color));
        this.drawables_.addElement(new Line3DDrawable(new Line3D(ll, ul), color));
        double unscaled = yLowTick;
        double scale = height / (maxY - minY);
        int numTicks = (int)((maxY - yLowTick) / yIncrement) + 1;
        this.strings_ = new String[numTicks];
        for (int i = 0; i < numTicks; ++i) {
            double y = -height / (double)2 + (unscaled - minY) * scale;
            Point3D p1 = transform.transform(new Point3D(-width / (double)2 - 0.01, y, 0.0));
            Point3D p2 = transform.transform(new Point3D(-width / (double)2, y, 0.0));
            this.drawables_.addElement(new Line3DDrawable(new Line3D(p1, p2), color));
            this.strings_[i] = new Double(unscaled).toString();
            Point3D labelOrigin = transform.transform(new Point3D(-width / (double)2 - 0.02, y, 0.0));
            this.drawables_.addElement(new Text2DDrawable(this.strings_[i], labelOrigin, 1, this.font_, labelColor));
            unscaled += yIncrement;
        }
        unscaled = xLowTick;
        scale = width / (maxX - minX);
        numTicks = (int)((maxX - xLowTick) / xIncrement) + 1;
        for (int i = 0; i < numTicks; ++i) {
            double x = -width / (double)2 + (unscaled - minX) * scale;
            Point3D p1 = transform.transform(new Point3D(x, -height / (double)2 - 0.01, 0.0));
            Point3D p2 = transform.transform(new Point3D(x, -height / (double)2, 0.0));
            this.drawables_.addElement(new Line3DDrawable(new Line3D(p1, p2), color));
            String label = new Double(unscaled).toString();
            Point3D labelOrigin = transform.transform(new Point3D(x, -height / (double)2 - 0.02, 0.0));
            this.drawables_.addElement(new Text2DDrawable(label, labelOrigin, 0, this.font_, labelColor));
            unscaled += xIncrement;
        }
    }

    public String[] getStrings() {
        return this.strings_;
    }

    public Font getFont() {
        return this.font_;
    }

    public void add2DTo(ChartGraphics chart) {
        for (int i = 0; i < this.drawables_.size(); ++i) {
            chart.add2DDrawable((Drawable)this.drawables_.elementAt(i));
        }
    }
}

